/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef __LOGGER_H
#define __LOGGER_H

#include <stdarg.h>

#ifdef WINCE_TEST 
extern FILE *fpLog;
#endif

/* call this to initialize the log engine */
void InitLogger(DRM_BOOL fLoggerEnabled);

/* call this first for each test case */
void LogStart(long lTC);

/************** 
*	You can optionally call this function in your test implementation to log your messages.
*	This function can be called multiple times.
*	szTag is the tag name in the xml log file. The usage of szMessageFmt and the variable arglist
*	is the same as sprintf.
***************/
void Log(char *szTag, char *szMessage, ...);
void vLog(char *szTag, char *szMessage, va_list argptr);

/* call this to log result. should be the last call for the test case */
void LogEnd(int fPass, char *szMessage,char *szTrace);

/* call this to uninitialize the log engin */
void UninitLogger(void);
 
#endif
